/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.annotation;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.PDLineDashPattern;

public class PDBorderStyleDictionary
implements COSObjectable {
    public static final String STYLE_SOLID = "S";
    public static final String STYLE_DASHED = "D";
    public static final String STYLE_BEVELED = "B";
    public static final String STYLE_INSET = "I";
    public static final String STYLE_UNDERLINE = "U";
    private COSDictionary dictionary;

    public PDBorderStyleDictionary() {
        this.dictionary = new COSDictionary();
    }

    public PDBorderStyleDictionary(COSDictionary dict) {
        this.dictionary = dict;
    }

    public COSDictionary getDictionary() {
        return this.dictionary;
    }

    @Override
    public COSBase getCOSObject() {
        return this.dictionary;
    }

    public void setWidth(float w) {
        this.getDictionary().setFloat("W", w);
    }

    public float getWidth() {
        return this.getDictionary().getFloat("W", 1.0f);
    }

    public void setStyle(String s) {
        this.getDictionary().setName(STYLE_SOLID, s);
    }

    public String getStyle() {
        return this.getDictionary().getNameAsString(STYLE_SOLID, STYLE_SOLID);
    }

    public void setDashStyle(PDLineDashPattern d) {
        COSArray array = null;
        if (d != null) {
            array = d.getCOSDashPattern();
        }
        this.getDictionary().setItem(STYLE_DASHED, (COSBase)array);
    }

    public PDLineDashPattern getDashStyle() {
        COSArray d = (COSArray)this.getDictionary().getDictionaryObject(STYLE_DASHED);
        if (d == null) {
            d = new COSArray();
            d.add(COSInteger.THREE);
            this.getDictionary().setItem(STYLE_DASHED, (COSBase)d);
        }
        return new PDLineDashPattern(d, 0);
    }
}

